% Fins Exposed to Clear Sky Overnight (Radiation Loss)
% Clear sky at night emits very little radiation 
clc; clear 
k=400; D=.004; h=150; e=0.8; sig=5.67e-8; 
T_inf=20+273; Tb=120+273;
Ac=D*D*pi/4; p=pi*D;
Lx=0.5; nx=150; dx=Lx/nx; dxs=dx*dx; nxp=nx+1;
c1=h*p*dxs/(k*Ac); c2=e*sig*p*dxs/(k*Ac); 
%
a=zeros(nxp); b=zeros(1,nxp); % establish the base for the sparse matrix.
x=linspace(0,Lx, nxp);
for i=2:nx; T(i)=Tb; end  % initial guess 
for iter=1:7
a(1,1)=1; b(1)=Tb;
for i=2:nx
a(i,i-1)=1; a(i,i)=-(2+c1); a(i,i+1)=1; b(i)=-c1*T_inf+c2*(T(i))^4;
end
a(nxp,nx)=-1; a(nxp,nxp)=1; % The tip of the fin is insulated.
T=a\b';
% monitor the convergence trend 
fprintf('%9.4f %9.4f %9.4f \n', T(2), T(nx/2), T(nxp))
end 
plot(x,T); axis([0 Lx 15+273 120+273]); hold off
xlabel('x'); ylabel('T(x) in K'); 
text(0.1, 360,'fin exposed to clear sky overnight')
qb = k*Ac*(T(1)-T(2))/dx    % = 9.8208
