clc; clear
m=.28; cv=4180; h=4.8; A=.01; % properties of the Coke
Tinf=25; Tp=5; % information regarding the temperatures 
time(1)=0; T(1)=Tp; % initial condition 
Lt=720*60; % the total length of time is 12 hours 
nt=200; % number of time intervals 
dt=Lt/nt; % the length of the time interval 
c1=h*A*dt/(m*cv); % a convenient dimensionless parameter 
for it=2:nt+1 
time(it)=(it-1)*dt; % for example, time(3)=2*dt 
T(it)= (Tp+c1*Tinf)/(1+c1); % governing equation 
Tp=T(it); % must remember to update Tp 
end 
plot(time/3600, T); grid on; 
xlabel('time in hours'); ylabel('T of Coke') 
times=interp1(T, time, 10)/60  % = 117.43 minutes 
text(times/60-0.1, 10, '**')
