clc; clear
%>>>>>>>>>> input data
qs=1200; h=4.5; Tinf=25; 
k=0.2; rho=800; cv=3000; aLf=k/(rho*cv); 
L=0.009; nx=10; dx=L/nx; dxs=dx*dx; nxp=nx+1; 
Lt=1800; nt=20; dt=Lt/nt; 
r=aLf*dt/dxs; bi=h*dx/k; qb=qs*dx/k; 
x=linspace(0,L,nxp); 
%>>>>>>>>>> initialize a and b, and prescribe the B. C.s 
a(nxp,nxp)=0; b(nxp)=0; 
a(1,1)=1; a(1,2)=-1; b(1)=qb;
a(nxp,nx)=-1; a(nxp,nxp)=1+bi; b(nxp)=bi*Tinf;
%
%>>>>>>>>>> initial condition
for i=1:nxp
Tp(i)=-2; 
end 
T1(1)=-2; time(1)=0; 
%
%>>>>>>>>>> interior-T gov. eq. 
for i = 2:nx
a(i,i-1)= -r; a(i,i)= 2*r + 1; a(i,i+1)= -r; 
end 
for it=2:nt+1
time(it)=(it-1)*dt; 
for i=2:nx; b(i)= Tp(i);end 
T=a\b'; Tp=T; 
T1(it)=T(1); Tnxp(it)=T(nxp); % = store up values of T1 and Tnxp 
plot(x,T); hold on; xlabel('x'); ylabel('T') 
text(0.001, 130, 'As time increases, the curve shifts up') 
end 
%plot(time, T1) 
hold off
%>>>>>>>>>> check the total energy balance 
sum1=0; sum2=0; 
for it=2:nt+1
sum1 =sum1+(qs-h*(Tnxp(it)-Tinf))*dt;
end
for i=2:nx
    sum2=sum2 + dx*rho*cv*(T(i)-(-2));
end
q_total = sum1 % = 1.9901e6 J/m^2
dU=sum2 % = 1.9901e6 J/m^2
