clc; clear
Tn = 0; TW=100; 
rho=8930; cv=385; k=400; aLf=k/(rho*cv); 
dx=0.1; dxs=dx*dx; 
Lt=120; nt=20; dt=Lt/nt; ntp=nt+1; % two minutes 
r=aLf*dt/dxs;
Tp=0; % initial condition 
time(1)=0; T(1)=0; 
for it=2:nt+1
    time(it)=(it-1)*dt; 
    T(it)=(Tp+TW*r)/(1+4*r); Tp=T(it);
end
plot(time, T); xlabel('time'); ylabel('T')
hold off
T(ntp) % = 24.82
% check the energy balance in the entire period of heating time
m = rho*dxs; 
dU= m*cv*(T(ntp)-T(1)) % = 8.5327e5
sum=0;
for it=2:ntp 
sum = sum + k*((100-T(it))-3*(T(it)-0))*dt;
end
Q = sum % = 8.5327e5 
