% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

clear all;
clc;

%% Aufgabe auswhlen

% Aufgabe (1, 2 3, oder 4)
% 1: Plot nichtlineare Modelle mit Sinusanregung
% 2: Plot nichtlineares Modell und lineares Modell mit Sinusanregung
% 3: Plot nichtlineares Modell und lineares Modell mit Rechteckanregung
% 4: Plot nichtlineares Modell und lineares Modell mit Rechteckanregung mit
% Phasenverschiebung
teil = 1;
% Arbeitspunkt (0 oder pi)
AP = 0; %pi;

%% Parameter laden
initModell;
[A,B,C,D] = initLinear(  l, mp, ms, Rs, Rp, g, AP );

switch teil
    case 1
        initModell;
        sim('Modelle');

        figure;
        ax(1) = subplot(3,1,1);
        cla;

        plot(datMO.time , datMO.signals.values(:,1) , '-k')
        grid on
        ylabel('F')

        ax(2) = subplot(3,1,2);
        cla;
        plot(datMO.time     , datMO.signals.values(:,2)     , '-k')
        hold on
        plot(datFcn.time    , datFcn.signals.values(:,2)    , '--k')
        plot(datSFcn.time   , datSFcn.signals.values(:,2)   , '-.k')
        grid on
        ylabel('x')

        ax(3) = subplot(3,1,3);
        cla;
        plot(datMO.time     , datMO.signals.values(:,3)     , '-k')
        hold on
        plot(datFcn.time    , datFcn.signals.values(:,3)    , '--k')
        plot(datSFcn.time   , datSFcn.signals.values(:,3)   , '-.k')
        grid on
        ylabel('phi')
        legend('Math-Op.' , 'Fcn-Block' , 'S-Fcn.')

        xlabel('t')



    case 2
        if AP == 0
            initModell;
            [A,B,C,D] = initLinear(  l, mp, ms, Rs, Rp, g, AP );
            sim('Modelle');

            figure
            ax(1) = subplot(3,1,1);
            cla;

            plot(datMO.time , datMO.signals.values(:,1) , '-k')
            grid on
            ylabel('F')

            ax(2) = subplot(3,1,2);
            cla;
            plot(datMO.time     , datMO.signals.values(:,2)     , '-k')
            hold on
            plot(datLin.time    , datLin.signals.values(:,2)    , '--k')
            grid on
            ylabel('x')

            ax(3) = subplot(3,1,3);
            cla;
            plot(datMO.time     , datMO.signals.values(:,3)     , '-k')
            hold on
            plot(datLin.time    , datLin.signals.values(:,3)    , '--k')
            grid on
            ylabel('phi')
            legend('nichtlinear' , 'linearisiert')

            xlabel('t')

        elseif AP == pi
            initModell;
            [A,B,C,D] = initLinear(  l, mp, ms, Rs, Rp, g, AP );
            sim('Modelle');

            figure
            ax(1) = subplot(3,1,1);
            cla;

            plot(datMO.time , datMO.signals.values(:,1) , '-k')
            grid on
            ylabel('F')

            ax(2) = subplot(3,1,2);
            cla;
            plot(datMO.time     , datMO.signals.values(:,2)     , '-k')
            hold on
            plot(datLin.time    , datLin.signals.values(:,2)    , '--k')
            grid on
            axis([0 20 0 1])
            ylabel('x')

            ax(3) = subplot(3,1,3);
            cla;
            plot(datMO.time     , datMO.signals.values(:,3)     , '-k')
            hold on
            plot(datLin.time    , datLin.signals.values(:,3)    , '--k')
            grid on
            axis([0 20 0 10])
            ylabel('phi')
            legend('nichtlinear' , 'linearisiert')

            xlabel('t')
        end

    case 3
        if AP == 0
            initModell;
            [A,B,C,D] = initLinear(  l, mp, ms, Rs, Rp, g, AP );
            sim('Modelle');

            figure
            ax(1) = subplot(3,1,1);
            cla;

            plot(datMO.time , datMO.signals.values(:,1) , '-k')
            grid on
            axis([0 10 -45 45])
            ylabel('F')

            ax(2) = subplot(3,1,2);
            cla;
            plot(datMO.time     , datMO.signals.values(:,2)     , '-k')
            hold on
            plot(datLin.time    , datLin.signals.values(:,2)    , '--k')
            grid on
            axis([0 10 -1 1.5])
            ylabel('x')

            ax(3) = subplot(3,1,3);
            cla;
            plot(datMO.time     , datMO.signals.values(:,3)     , '-k')
            hold on
            plot(datLin.time    , datLin.signals.values(:,3)    , '--k')
            grid on
            axis([0 10 -2 2])
            ylabel('phi')
            legend('nichtlinear' , 'linearisiert', 'Location' , 'northeast')

            xlabel('t')

        elseif AP == pi
            AP = pi;
            initModell;
            [A,B,C,D] = initLinear(  l, mp, ms, Rs, Rp, g, AP );
            sim('Modelle');

            figure
            ax(1) = subplot(3,1,1);
            cla;

            plot(datMO.time , datMO.signals.values(:,1) , '-k')
            grid on
            axis([0 10 -45 45])
            ylabel('F')

            ax(2) = subplot(3,1,2);
            cla;
            plot(datMO.time     , datMO.signals.values(:,2)     , '-k')
            hold on
            plot(datLin.time    , datLin.signals.values(:,2)    , '--k')
            grid on
            axis([0 10 -1 2])
            ylabel('x')

            ax(3) = subplot(3,1,3);
            cla;
            plot(datMO.time     , datMO.signals.values(:,3)     , '-k')
            hold on
            plot(datLin.time    , datLin.signals.values(:,3)    , '--k')
            grid on
            axis([0 10 0 10])
            ylabel('phi')
            legend('nichtlinear' , 'linearisiert', 'Location' , 'southeast')

            xlabel('t')
        end


    case 4
        if AP == 0
            initModell;
            [A,B,C,D] = initLinear(  l, mp, ms, Rs, Rp, g, AP );
            sim('Modelle');

            figure
            ax(1) = subplot(3,1,1);
            cla;

            plot(datMO.time , datMO.signals.values(:,1) , '-k')
            grid on
            axis([0 10 -45 45])
            ylabel('F')

            ax(2) = subplot(3,1,2);
            cla;
            plot(datMO.time     , datMO.signals.values(:,2)     , '-k')
            hold on
            plot(datLin.time    , datLin.signals.values(:,2)    , '--k')
            grid on
            axis([0 10 -15 1.5])
            ylabel('x')

            ax(3) = subplot(3,1,3);
            cla;
            plot(datMO.time     , datMO.signals.values(:,3)     , '-k')
            hold on
            plot(datLin.time    , datLin.signals.values(:,3)    , '--k')
            grid on
            axis([0 10 -2 2])
            ylabel('phi')
            legend('nichtlinear' , 'linearisiert', 'Location' , 'northeast')

            xlabel('t')

        elseif AP == pi
            initModell;
            [A,B,C,D] = initLinear(  l, mp, ms, Rs, Rp, g, AP );
            sim('Modelle');

            figure
            ax(1) = subplot(3,1,1);
            cla;

            plot(datMO.time , datMO.signals.values(:,1) , '-k')
            grid on
            axis([0 10 -45 45])
            ylabel('F')

            ax(2) = subplot(3,1,2);
            cla;
            plot(datMO.time     , datMO.signals.values(:,2)     , '-k')
            hold on
            plot(datLin.time    , datLin.signals.values(:,2)    , '--k')
            grid on
            axis([0 10 -15 1])
            ylabel('x')

            ax(3) = subplot(3,1,3);
            cla;
            plot(datMO.time     , datMO.signals.values(:,3)     , '-k')
            hold on
            plot(datLin.time    , datLin.signals.values(:,3)    , '--k')
            grid on
            axis([0 10 -4 4])
            ylabel('phi')
            legend('nichtlinear' , 'linearisiert', 'Location' , 'southeast')

            xlabel('t')
        end
end