% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

function [vT, mX, mB, vU] = runPendel(stPendel, AP, K,  x0, stObs)

	xArbeitspunkt = [0, 0, AP, 0];

	% Fr Modell ntige Variablen im Base-Workspace anlegen
	assignin('base', 'xArbeitspunkt', xArbeitspunkt);
	
    assignin('base', 'stPendel', stPendel);
	assignin('base', 'x0', x0);
	assignin('base', 'K', K);
	
	% Wenn 5 Argumente bergeben wurden UND stObs nicht leer ist
	% wird der Beobachter verwendet
	if ((nargin == 5) && ~isempty(stObs))
		
		x0obs = stObs.x0;
		% In stObs.x0 wird Winkel absolut angegeben
		x0obs(3) = x0obs(3) - AP;
		
		assignin('base', 'x0_obs', x0obs);
		assignin('base', 'L', stObs.L);
		assignin('base', 'A', stObs.A);
		assignin('base', 'B', stObs.B);
		assignin('base', 'C', stObs.C);
		
		assignin('base', 'wahl', -1);
	else
		% Diese Variablen mssen auch dann im
		% Workspace definiert sein, wenn kein
		% Beobachter verwendet wird.
		assignin('base', 'x0_obs', zeros(4,1));
		assignin('base', 'L', zeros(4,2));
		assignin('base', 'A', zeros(4,4));
		assignin('base', 'B', zeros(4,1));
		assignin('base', 'C', zeros(4,2));

		assignin('base', 'wahl', 1);
	end % if ((nargin == 5) && ~isempty(stObs))

	
	% Simulation ausfhren (hier mit fester Dauer von 10 Sekunden)
	% Modellierte Zeitpunkte in "vT" speichern
	vT = sim('Regelung_V4', 10);
	
	% Modell schreibt "mZustand" in den Workspace.
	% Dieses als "mX" zurckgeben.
	mX = mZustand;
	% Entsprechend "vInput" als "vU"
	vU = vStell;
	% und "mBeobachter" als "mB" zurckgeben.
    mB = mBeobachter;
	% mBeobachter enthlt relativen Winkel
	mB(:, 3) = mB(:, 3) + AP;
    
end % function runPendel
    