% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

function dxdt = RandwertproblemDGL(t, x, P, stPendel, T)
	% t:			Zeit
	% x:			Zustnde x(1) und x(2)
	% P:			freie Parameter p1 und p2
	% Pendeldaten:	Pendeldaten
	% T:			bergangszeit

	persistent m s J g sT p1 p2;

	if (nargin > 3)
		m = stPendel.mPendel;
		l = stPendel.lPendel;
		s = l/2;
		g = stPendel.g;
		J = 1/12 * stPendel.mPendel * stPendel.lPendel^2;
		sT = T;
		dxdt = 0;
		return;
	end

	p1 = P(1);
	p2 = P(2);

	% Steuergesetz mit noch unbekannten Parametern p1 und p2
	u = ( 6*(-p1 - 3*p2)*(t/sT) + 12*(3*p1 + 8*p2)*(t/sT)^2 + ...
			20*(-3*p1 - 6*p2)*(t/sT)^3 +...
			30*p1*(t/sT)^4 + 42*p2*(t/sT)^5 ) / (sT^2);

	% Differentialgleichung 2ter Ordnung, x(1): Winkel,
	% x(2): Winkelgeschwindigkeit
	dxdt = [	x(2) ; ...
				-m*s*g/(m*s^2+J)*sin(x(1)) ...
						- m*s/(m*s^2+J)*cos(x(1))*u;	];  % f(4) + g(4) * u

end % function RandwertproblemDGL
