% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

% Darstellung der Lsung des berechneten Randwertproblems

T = stTraj.T;
vTGrenze = [0; T];
vX1Grenze = [1; 1] * 0.5;
vX2Grenze = [1; 1] * 1.6;
vUGrenze = [1; 1] * 12;
vPiGrenze = [1; 1] * pi;

% Ausgabe der Stellgrenfolge
figure
subplot (5, 1, 1);
plot(stTraj.vT, stTraj.vU, ...
		vTGrenze, vUGrenze, 'k', vTGrenze, -vUGrenze, 'k');
title('Stellgrenverlauf');
ylabel('u^*(t) [m/s^2]');

% Ausgabe der Trajektorie Weg
subplot (5, 1, 2);
plot(stTraj.vT, stTraj.mX(1,:), ...
		vTGrenze, vX1Grenze, 'k', vTGrenze, -vX1Grenze, 'k');
title('Trajektorie Weg');
ylabel('x_1^*(t) [m]');

% Ausgabe der Trajektorie Geschwindigkeit
subplot (5, 1, 3);
plot(stTraj.vT, stTraj.mX(2,:), ...
		vTGrenze, vX2Grenze, 'k', vTGrenze, -vX2Grenze, 'k');	
title('Trajektorie Geschwindigkeit');
ylabel('x_2^*(t) [m/s]');

% Ausgabe der Trajektorie Winkel
subplot (5, 1, 4);
plot(stTraj.vT, stTraj.mX(3,:), ...
		vTGrenze, vPiGrenze, 'k');	
title('Trajektorie Winkel');
ylabel('x_3^*(t) [rad]');

% Ausgabe der Trajektorie Winkelgeschwindigkeit
subplot (5, 1, 5);
plot(stTraj.vT, stTraj.mX(4,:));
title('Trajektorie Winkelgeschwindigkeit');
ylabel('x_4^*(t) [rad/s]');
xlabel('Zeit t [s]');


%animierePendel(stTraj.vT, stTraj.mX', Pendeldaten, [], 0.01, 0);
