% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

function [vTK, mK] = berechneK(stPendel, stTraj, Q, R)

	% Anfangswert (bzw. Endwert) von P aus algebraischer
	% Riccatigleichung bestimmen.
	
	vXe = [0, 0, pi, 0].';
	u0 = 0;
	[Ae, Be] = linPendelZR2(stPendel, vXe, u0);

	S = zeros(size(Be));
	E = eye(size(Ae));

	Pe = care(Ae, Be, Q, R, S, E);


	% Zeitpunkte festlegen, fr die P(t) bestimmt werden soll
	T = stTraj.T;
%	vTP = linspace(T, 0, 100);
	vTP = linspace(T, 0, length(stTraj.vT));


	% Riccati-Differentialgleichung initialisieren
	RiccatiDGL(0, 0, stPendel, stTraj, Q, R);
    % Pe = reshape(Pe, size(Ae,1)*size(Ae,1),1)    
	% Riccati-Differentialgleichung lsen
	[vTP, mP] = ode45(@RiccatiDGL, vTP, Pe);
    

	% Riccati-DGL wurde rckwrts gelt, daher wieder
	% richtig rum drehen
	vTP = flipud(vTP);
	mP = flipud(mP);
%     figure
%     plot(vTP,mP)
	% K fr alle Zeitpunkte bestimmen
	[vTK, mK] = getK(vTP, mP, stPendel, stTraj, R);
%     figure
%     plot(vTK,mK)
end % function berechneK


% subfunction getK
function [vT, mK] = getK(vT, mP, stPendel, stTraj, R)

	n = sqrt(size(mP,2));
		
	mK = zeros(length(vT), n);
	
	for i_t = 1:length(vT)
		t = vT(i_t);
		
		% Aus Zeit Arbeitspunkt berechnen
		vX0 = interp1(stTraj.vT, stTraj.mX.', t);
		vX0 = vX0';

		u0 = interp1(stTraj.vT, stTraj.vU.', t);

		% Um Arbeitspunkt linearisieren
		[~, B] = linPendelZR2(stPendel, vX0, u0);
        
		
		% P wieder in Matrixform bringen
		P = reshape(mP(i_t, :), n, n);
		
		% K zum aktuellen Zeitschritt berechnen
		mK(i_t, :) = R \ B.' * P;
	end
end % subfunction getK