function [myPi, elapsedTime] = monteCarloFunc(iter, plotFlag)
% Monte-Carlo simulation of estimating pi
% Usage:
% monteCarloParallel(10000, true)
% monteCarloParallel(10000, false)
tic

% Create data queue for plotting
q = parallel.pool.DataQueue;

if plotFlag
    f = figure;
    ax = axes(f);
    ax.XLim = [0 1];
    ax.YLim = [0 1];
    s = scatter(ax, [], [], 'filled');

    q.afterEach(@(x) updateScatter(s, x));
end

% Calc pi
R = 1;
if ischar(iter)
    iter = str2double(iter);
end
count = zeros(iter, 1, 'int8');

if plotFlag
    parfor n = 1:iter
        x = R * rand(1);
        y = R * rand(1);
        if x^2 + y^2 < R^2
            count(n, 1) = 1;
            send(q, [n, x, y, [0 0 1]]);
        else
            send(q, [n, x, y, [1 0 0]]);
        end
    end
else
    parfor n = 1:iter
        x = R * rand(1);
        y = R * rand(1);
        if x^2 + y^2 < R^2
            count(n, 1) = 1;
        end
    end
end

totalCounts = sum(count);
myPi = 4 * totalCounts / iter;

elapsedTime = toc;
end