/*
 *	engdemo.c
 *
 *	A simple program to illustrate how to call MATLAB
 *	Engine functions from a C program.
 *
 * Copyright 1984-2022 The MathWorks, Inc.
 * All rights reserved
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "engine.h"
#define  BUFSIZE 256

int main()

{
	Engine *ep;
	mxArray *T = NULL, *result = NULL;
	char buffer[BUFSIZE+1];
	double time[11] = { 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0 };

	/*
	 * Call engOpen with a NULL string. This starts a MATLAB process 
     * on the current host using the command "matlab".
	 */
	if (!(ep = engOpen(""))) {
		fprintf(stderr, "\nCan't start MATLAB engine\n");
		return EXIT_FAILURE;
	}

	/*
	 * PART I
	 *
	 * For the first half of this demonstration, send data
	 * to MATLAB, analyze the data, and plot the result.
	 */

	/* 
	 * Create a variable for the data
	 */
	T = mxCreateDoubleMatrix(1, 11, mxREAL);
	memcpy((void *)mxGetPr(T), (void *)time, sizeof(time));
	/*
	 * Place the variable T into the MATLAB workspace
	 */
	engPutVariable(ep, "T", T);

	/*
	 * Evaluate a function of time, distance = (1/2)g.*t.^2
	 * (g is the acceleration due to gravity)
	 */
	engEvalString(ep, "D = .5.*(-9.8).*T.^2;");

	result = engGetVariable(ep, "D");
	double* resultD = mxGetPr(result);
	for (int i=0; i<11; i++){
	    printf("%lf\t%lf\n", time[i], resultD[i]);
	}
	engClose(ep);
	
	return EXIT_SUCCESS;
}

