#include "fintrf.h"
C
#if 0
C
C     fengdemo.F
C     .F file need to be preprocessed to generate .for equivalent
C
#endif
C
C     fengdemo.f
C
C     This is a simple program that illustrates how to call the MATLAB
C     Engine functions from a FORTRAN program.
C
C Copyright 1984-2022 The MathWorks, Inc.
C======================================================================
C 

      program main

C     Declarations
      implicit none

      mwPointer engOpen, engGetVariable, mxCreateDoubleMatrix
#if MX_HAS_INTERLEAVED_COMPLEX
      mwPointer mxGetDoubles
#else
      mwPointer mxGetPr
#endif
      mwPointer ep, T, D 
      double precision time(10), dist(10)
      integer engPutVariable, engEvalString, engClose
      integer temp, status
      mwSize i
      data time / 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0 /
      
      mwSize M, N
      parameter(M=1) 
      parameter(N=10) 

C
      ep = engOpen('matlab -nodisplay')
C
      if (ep .eq. 0) then
         write(6,*) 'Can''t start MATLAB engine'
         stop
      endif
C
      T = mxCreateDoubleMatrix(M, N, 0)
#if MX_HAS_INTERLEAVED_COMPLEX
      call mxCopyReal8ToPtr(time, mxGetDoubles(T), N)
#else
      call mxCopyReal8ToPtr(time, mxGetPr(T), N)
#endif
C
C
C     Place the variable T into the MATLAB workspace
C
      status = engPutVariable(ep, 'T', T)
C
      if (status .ne. 0) then 
         write(6,*) 'engPutVariable failed'
         stop
      endif
C
C
C     Evaluate a function of time, distance = (1/2)g.*t.^2
C     (g is the acceleration due to gravity)
C     
      if (engEvalString(ep, 'D = .5.*(-9.8).*T.^2;') .ne. 0) then
         write(6,*) 'engEvalString failed'
         stop
      endif

C      
      D = engGetVariable(ep, 'D')
#if MX_HAS_INTERLEAVED_COMPLEX
      call mxCopyPtrToReal8(mxGetDoubles(D), dist, N)
#else
      call mxCopyPtrToReal8(mxGetPr(D), dist, N)
#endif
      print *, 'MATLAB computed the following distances:'
      print *, '  time(s)  distance(m)'
      do 10 i=1,10
         print 20, time(i), dist(i)
 20      format(' ', G10.3, G10.3)
 10   continue
C	
C     
      call mxDestroyArray(T)
      call mxDestroyArray(D)
      status = engClose(ep)
C      
      if (status .ne. 0) then 
         write(6,*) 'engClose failed'
         stop
      endif
C
      stop
      end

